;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Phanto Generator
;;
;; Spawns Phantos when Mario is holding the appropriate item.
;;
;; Usage:
 main:
		LDA #$00	; <Count>
		XBA
		LDA #$00	; <Ex1>
		LDX #$01	; <ExBit>
		LDY #$0F	; <Rate>
		JSL SpawnPhanto
		RTL
;; <Ex1> indicates the Extra Byte 1 value to check for and spawn.
;; <ExBit> indicates if you want set the Extra Bit. Put any value, and it'll count that's true.
;; <Count> indicates the max number of Phantos minus 1. If 0, only spawn 1.
;; <Rate> indicates how frequently to poll for existing Phantos or generate new ones:
;; 	- $01 <- fastest (every other frame)
;; 	- $03
;; 	- $07
;; 	- $0F
;; 	- $1F
;; 	- $3F
;; 	- $7F
;; 	- $FF <- slowest (a little more than 4 seconds)

!SprNum =	$16

SpawnPhanto:
	!SprSize = $0C
if !sa1
	!SprSize = $16
endif
	STA $0C
	XBA
	STA $0D
	STX $0F
	STY $0E

	LDA $14
	AND $0E
	ORA $9D
	ORA $1490|!addr
	BEQ +
.NoSpawn
	RTL

+	STZ $00
	LDY #!SprSize-1
-	PHX
	TYX
	LDA !7FAB9E,x
	PLX
	CMP.b #!SprNum
	BNE +
	PHX
	TYX
	LDA !extra_byte_1,x
	PLX
	CMP $0C
	BNE +
	LDA !14C8,y
	CMP #$08
	BNE +
;; we're only counting sprites spawned through shooters or other sprites
;; not ones placed in a level
	INC $00
+	DEY
	BPL -
;; reset time if too many sprites exist
	LDA $0D
	CMP $00
	BCC .NoSpawn
	LDA $0C
	JSL PhantoGetCarried
	BCC .NoSpawn
;; spawn sprite

	LDX #!SprSize-1
-	LDA !14C8,x
	BEQ +
	DEX
	BPL -
	RTS
+
	LDA #!SprNum
        STA !9E,x
	JSL $07F7D2|!bank
        LDA #!SprNum
	STA !7FAB9E,x
	JSL $0187A7|!bank

	LDA #$08
	STA !14C8,x

	LDY $0F
	BEQ +
	LDA #$0C
+	STA !7FAB10,x

	LDA $0C
	STA !extra_byte_1,x
	STA !1510,x
	LDA #$02
	STA !C2,x

	JSL $01ACF9|!bank
	REP #$20
	AND #$007F
	SEC
	SBC #$0040
	CLC
	ADC $96
	SEP #$20
	STA !D8,x
	XBA
	STA !14D4,x

	LDY #$00
	LDA $7B
	BMI +
	INY #2
+	CLC
	ADC #$08
	CMP #$10
	BCS +

.RandomPosition
	JSL $01ACF9|!bank
	AND #$01
	ASL
	TAY
+	REP #$20
	LDA $1A
	CLC
	ADC .X_Disp,y
	SEP #$20
	STA !E4,x
	XBA
	STA !14E0,x
	RTL

.X_Disp	dw $FFE0,$0110

PhantoGetCarried:
	XBA
	LDA $18E2|!addr
	BEQ .NoYoshiFound
	PHX
	DEC
	TAX
	LDA !160E,x
	BMI +
	TAX
	JSL .GetSpriteList
	PLX
	BCC .NoYoshiFound
	LDY #$01
	SEC
	RTL
+	PLX
.NoYoshiFound
	LDA $1470|!addr
	ORA $187A|!addr
	BEQ .NoSpriteFound
	PHX
	LDX.b #!SprSize-1
-	CPX $15E9|!addr
	BEQ .Loop
	LDA !14C8,x
	CMP #$0B
	BNE .Loop
.GetYoshiMouthItem
	JSL .GetSpriteList
	BCC .Loop
	PLX
	LDY #$00
	RTL
.Loop	DEX
	BPL -
	PLX
.NoSpriteFound
	CLC
	RTL

.GetSpriteList
	XBA : STA $02 : XBA
	LDA !7FAB10,x : AND #$08 : BNE ..IsCustom
..IsNotCustom
	STZ $01
	LDA !9E,x : STA $00
	BRA ..LookForMatch
..IsCustom
	LDA #$01 : STA $01
	LDA !7FAB9E,x : STA $00
..LookForMatch
	PHX : LDX.b #(.SpriteList_end-.SpriteList-3)
-	LDA $00 : CMP.l .SpriteList+0,x : BNE ..SkipSprite
	LDA $01 : CMP.l .SpriteList+1,x : BNE ..SkipSprite
	LDA $02 : CMP.l .SpriteList+2,x : BNE ..SkipSprite
	PLX : SEC : RTL
..SkipSprite
	DEX #3 : BPL -
	PLX : CLC : RTL

.SpriteList
;;	  <Spr>  <Custom> <ExtraByte>
	db $80 : db $00 : db $00	; x00
	db $53 : db $00 : db $01	; x01
..end

;; <Spr> dictates the sprite number of the sprite being carried. Ideally, don't use duplicates here.
;; <Custom>, when non-zero, dictates that the sprite is a custom sprite being carried.
;; <ExtraByte> dictates the Extra Byte 1 setting that the Phanto must be. Ideally, don't use duplicates here.
